C      *****************************************************************
C      * Subroutine BackSub                                            *
C      * Solves for X in the eqn [A]X=Y where A is a matrix of n by n  *
C      * coefficients for a set of linear simultaneous eqns in n       *
C      * variables.  The [A] matrix has been augmented by the vector Y *
C      * which represents the right hand side of each equation.  X is  *
C      * the vector which represents the variables of the equations.   *
C      *                                                               *
C      * Variables:                                                    *
C      * A         -Input - A matrix of size "Size" by ("Size"+1).     *
C      *                    The "Size" by "Size" portion of the matrix *
C      *                    contains the coefficents of "Size"         *
C      *                    equations in "Size" unknowns, and the      *
C      *                    "Size"+1st column is the right hand side   *
C      *                    vector of constant terms.  "Size" is equal *
C      *                    to the number of components in the system. *
C      *                    Units are consistent with inputs.          *
C      *                    (Common block VGauss, file VGauss.f).      *
C      * Col       -Local - Column index into matrix A and vector X.   *
C      *                    Unitless.                                  *
C      * Order     -Input - A vector of size "Size" which orders the   *
C      *                    rows of A so that in this order A is an    *
C      *                    upper triangular matrix.  Unitless.        *
C      *                    (Common block VGauss, file VGauss.f).      *
C      * Row       -Local - Row index into matrix A.  Unitless.        *
C      * Size      -Input - The number of chemical components in the   *
C      *                    system.  Unitless.                         *
C      *                    (Common block VGauss, file VGauss.f).      *
C      * X         -Output- A vector of the values of the "Size"       *
C      *                    variables that solve the "Size" equations  *
C      *                    represented in matrix A.  Units are        *
C      *                    consistent with matrix A.                  *
C      *                    (Common block VGauss, file VGauss.f).      *
C      *****************************************************************
       SUBROUTINE BACKSUB
							IMPLICIT NONE
							INCLUDE 'VGAUSS.INC'
							INTEGER ROW, COL
							REAL*8 SUM
	   
C      *-----------------------------------------------------------*
C      * Solve for X(Size) the value for the last variable in the  *
C      * list by using the bottom equation in the upper triangular *
C      * matrix.  This equation has zero coeff. for all variables  *
C      * except the last one so the value for the variable is the  *
C      * just the right hand side divided by the coefficient.      *
C      *-----------------------------------------------------------*
       X(SIZE) = A(ORDER(SIZE), SIZE+1) / A(ORDER(SIZE),SIZE)
	   
C      *-----------------------------------------------------------*
C      * Back substitute these values through the rest of the eqns *
C      *-----------------------------------------------------------*
       DO 100 ROW=SIZE-1, 1, -1
	         SUM = 0
	      	  DO 110 COL = ROW+1, SIZE
	      	     SUM = SUM + A(ORDER(ROW), COL) * X(COL)
  110     CONTINUE
          X(ROW) = (A(ORDER(ROW), SIZE+1) - SUM)/ A(ORDER(ROW), ROW)
  100  CONTINUE

       RETURN
	      END
C      *****************************************************************
C      *                    END SUBROUTINE                             *
C      *****************************************************************
